#!/bin/sh




DMG_NAME="kesmac.dmg"
PACKAGE_NAME="kesmac.pkg"
GDPR_CONFIG_FILE="/tmp/klgdprconfig"
KL_INSTALLER_STARTUP_DIR_FILE="/tmp/kes/kes_installer_pwd"
KL_INSTALLER_STARTUP_DIR=
KL_BIN_DIR="/usr/local/bin"
SKIP_CHOICES=()
FORCE_CHOICES=()
MOUNT_DIR=
ACCEPT_KSN_EULA_PRESENT=0


choice_excluded()
{
    for e in $SKIP_CHOICES; do
        [[ "$e" == "$1" ]] && return 1;
    done
    return 0
}

choice_forced()
{
    for e in $FORCE_CHOICES; do
        [[ "$e" == "$1" ]] && return 1;
    done
    return 0
}

cleanup () {

	echo "cleanup started"
	echo "Unmount disk image $MOUNT_DIR"
	hdiutil detach "$MOUNT_DIR"
	echo "Remove $GDPR_CONFIG_FILE"
	rm -f "$GDPR_CONFIG_FILE"
	echo "cleanup finished"
	return 0
}


install()
{
    PKG_PACKAGE_NAME="$MOUNT_DIR/Kaspersky Installer.app/Contents/Packages/$PACKAGE_NAME"


    CHOICES_FILE=$(mktemp -t install_choices)
    CHOICE_CHANGES_FILE=$(mktemp -t install_choices)


    echo "<?xml version="1.0" encoding="UTF-8"?><!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd"><plist version="1.0"><array/></plist>" > "$CHOICE_CHANGES_FILE"

    installer -showChoicesXML -pkg "$PKG_PACKAGE_NAME" -target / > "$CHOICES_FILE" || return $?


    MODIFY_INDEX=0
    for CHOICE_INDEX in {0..99}
    do
        CHOICE_INFO_FILE=$(mktemp -t install_choices.$CHOICE_INDEX)
        /usr/libexec/PlistBuddy -x -c "Print :0:childItems:$CHOICE_INDEX" "$CHOICES_FILE" >> "$CHOICE_INFO_FILE" 2> /dev/null
        if [ $? -ne 0 ]; then
            break;
        fi


        CHOICE_IDENTIFIER=$(/usr/libexec/PlistBuddy -c "Print :choiceIdentifier" "$CHOICE_INFO_FILE")
        INSTALL_FLAG=$(/usr/libexec/PlistBuddy -c "Print :choiceIsSelected" "$CHOICE_INFO_FILE")

        choice_excluded "$CHOICE_IDENTIFIER"
        if [ $? -eq 1 ]; then

            if [ $INSTALL_FLAG -eq 0 ]; then

                continue;
            fi
            INSTALL_FLAG=0
        else
            choice_forced "$CHOICE_IDENTIFIER"
            if [ $? -eq 1 ]; then
                if [ $INSTALL_FLAG -eq 1 ]; then

                    continue;
                fi
                INSTALL_FLAG=1
            else

                continue;
            fi
        fi


        /usr/libexec/PlistBuddy -c "Add :$MODIFY_INDEX dict" "$CHOICE_CHANGES_FILE" || return $?
        /usr/libexec/PlistBuddy -c "Add :$MODIFY_INDEX:attributeSetting integer $INSTALL_FLAG" "$CHOICE_CHANGES_FILE" || return $?
        /usr/libexec/PlistBuddy -c "Add :$MODIFY_INDEX:choiceAttribute string selected" "$CHOICE_CHANGES_FILE" || return $?
        /usr/libexec/PlistBuddy -c "Add :$MODIFY_INDEX:choiceIdentifier string $CHOICE_IDENTIFIER" "$CHOICE_CHANGES_FILE" || return $?

        ((MODIFY_INDEX++))
    done


    installer -applyChoiceChangesXML "$CHOICE_CHANGES_FILE" -pkg "$PKG_PACKAGE_NAME" -target /
    SUCCESS=$?


    if [ $SUCCESS -ne 0 ]
    then
        echo "failed to install package"
    else
        echo "successfully installed package"
    fi

    hdiutil detach "$MOUNT_DIR"

    rm "$KL_INSTALLER_STARTUP_DIR_FILE"
    rmdir "/tmp/kes/"

    return $SUCCESS;
}

update_bases()
{
    echo "Checking satellite update folder..."

    UPDATE_DIR="$KL_INSTALLER_STARTUP_DIR/Update"

    if [ -d  "$UPDATE_DIR" ]; then
        "$KL_BIN_DIR/kav" update "$UPDATE_DIR"
    else
        echo "No updates found"
    fi

    return 0
}

install_key()
{
    ACTIVATION_CODE_SIZE=23

    echo "Looking for preinstalled keys..."
    for KEY_FILE in $(ls "$KL_INSTALLER_STARTUP_DIR" | grep ".key"); do
        echo "Trying to install $KEY_FILE..."

		FILESIZE=$(stat -f%z "$KEY_FILE")

        if [ "$FILESIZE" == "$ACTIVATION_CODE_SIZE" ]; then
			echo "Activation 2.0 method detected..."
            KEY_CODE=$(cat $KEY_FILE)
			"$KL_BIN_DIR/kav" addkey "$KEY_CODE" && break;
        else
			echo "Activation 1.0 method detected..."
			"$KL_BIN_DIR/kav" addkey "$KL_INSTALLER_STARTUP_DIR/$KEY_FILE" && break;
        fi
    done
}

print_usage()
{
    echo "usage: install.sh [--nogui] [--accept_ksn_eula]"
}

function run_python() {
    GDPR_PLIST_WRAPPER_IMPORT_PATH="$MOUNT_DIR/Kaspersky Installer.app/Contents/Packages"
    python -c "import sys; sys.path.insert(0, '$GDPR_PLIST_WRAPPER_IMPORT_PATH'); from gdpr_plist_wrapper import *; $1($2)" || { echo "run_python failed with args: $1($2)"; return 1; }
}

parse_arguments()
{
    if [[ $# -ge 1  &&  ("$1" = "-h") || ("$1" = "--help") ]]; then
        print_usage
        exit 0
    fi

    KL_INSTALLER_STARTUP_DIR=$(dirname "$0")


    mkdir -pv "/tmp/kes/"
    echo "$KL_INSTALLER_STARTUP_DIR" > "$KL_INSTALLER_STARTUP_DIR_FILE"


    MOUNT_DIR=$(hdiutil attach -noautoopen -nobrowse "$KL_INSTALLER_STARTUP_DIR/$DMG_NAME" | egrep 'Volumes' | grep -o "/Volumes/.*")
    if [ $? -ne 0 ]; then
        echo "Could not mount the $KL_INSTALLER_STARTUP_DIR/$DMG_NAME"
        return 22
    fi

    BUNDLE_GDPR_CONFIG_FILE="$MOUNT_DIR/Kaspersky Installer.app/Contents/Packages/gdpr_wizard_config.plist"
    cp -fv "$BUNDLE_GDPR_CONFIG_FILE" "$GDPR_CONFIG_FILE" || { echo "cp $BUNDLE_GDPR_CONFIG_FILE $GDPR_CONFIG_FILE failed"; return 1; }

    while [[ $# -ge 1 ]]
    do
        key="$1"
        case $key in
        --accept_ksn_eula)
            run_python 'set_agreement_field' "'Eula', 'accepted', 1" || { echo "set Eula.accepted failed"; return 1; }
            run_python 'set_agreement_field' "'Ksn', 'accepted', 1" || { echo "set Ksn.accepted failed"; return 1; }
            run_python 'set_agreement_field' "'ExtendedKSN', 'accepted', 1" || { echo "set ExtendedKSN.accepted failed"; return 1; }
            ACCEPT_KSN_EULA_PRESENT=1
            ;;
        --nogui)

            SKIP_CHOICES+=("installer_choice_6")
            ;;
        *)

            echo "invalid argument '$key' passed"
            print_usage
            return 2
            ;;
        esac
        shift
    done
}

get_ini_param_value()
{


    PARAM_NAME=$1
    INDEX=0
    for NAME in ${SECTION_PARAM_NAMES[*]}; do
        if [[ "$NAME" == "$PARAM_NAME" ]]; then
            echo ${SECTION_PARAM_VALUES[$INDEX]}
            return 0;
        fi
        INDEX=$[$INDEX + 1]
    done
    return 1
}

read_ini_section()
{
    SECTION_PARAM_NAMES=()
    SECTION_PARAM_VALUES=()

    SECTION_NAME=$1
    INI_FILE=$2

    SECT1=$(mktemp -t inip)
    SECT2=$(mktemp -t inip)


    cat "$INI_FILE" | grep -A 100 "\[$SECTION_NAME\]" | grep -v "\[$SECTION_NAME\]" > "$SECT1"


    cat "$SECT1" | grep -B 100 -m 1 '^\[' | grep -v '^\[' > "$SECT2"
    [ -s "$SECT2" ] || cp "$SECT1" "$SECT2"


    while read LINE; do
        ARRAY=(${LINE//=/ })
        PARAM=${ARRAY[0]//$'\r'/}
        VALUE=${ARRAY[1]//$'\r'/}

        if [[ ! -z $PARAM ]]; then
            SECTION_PARAM_NAMES+=($PARAM)
            SECTION_PARAM_VALUES+=($VALUE)
        fi
    done < "$SECT2"
    




    return 0
}

parse_kud()
{

    KUD_FILE="$KL_INSTALLER_STARTUP_DIR/kesmac.kud"


    read_ini_section "Packages" "$KUD_FILE"

    INDEX=2
    for PACKAGE in "FileAV" "WebAV" "IDS" "Connector" "GUI"; do
        OPTION=$(get_ini_param_value "$PACKAGE")
        if [ "$OPTION" == "1" ]; then
            FORCE_CHOICES="$FORCE_CHOICES installer_choice_$INDEX"
            echo "Including $PACKAGE"
        fi
        if [ "$OPTION" == "0" ]; then
            SKIP_CHOICES="$SKIP_CHOICES installer_choice_$INDEX"
            echo "Excluding $PACKAGE"
        fi
        INDEX=$[$INDEX + 1]
    done

    if ((!$ACCEPT_KSN_EULA_PRESENT))
    then

        read_ini_section "KSN" "$KUD_FILE"
        run_python 'set_agreement_field' "'Eula', 'accepted', 1" || { echo "set Eula.accepted failed"; return 1; }
        run_python 'set_agreement_field' "'Ksn', 'accepted', $(get_ini_param_value "KsnCheck")" || { echo "set Ksn.accepted failed"; return 1; }
        run_python 'set_agreement_field' "'ExtendedKSN', 'accepted', $(get_ini_param_value "KsnExtendedCheck")" || { echo "set ExtendedKSN.accepted failed"; return 1; }
    fi

    return 0
}


parse_arguments $@ || { echo "parse_arguments failed"; cleanup; exit 1; }
parse_kud || { echo "parse_kud failed"; cleanup; exit 1; }

install || { echo "install failed"; cleanup; exit 1; }
install_key
update_bases
